setwd('U:/MyStuff/cls/p205c/EXAMPLES/holzinger/r')
library(lavaan)
library(psych)

#-------------------------------------------------------------------------------------------------#
# reading a data set into R (data in ASCII format, with . for missing values)                     #
#   change element in na.strings statement to substitute a different missing value (e.g., -99)    #
#-------------------------------------------------------------------------------------------------#

hs39all = read.table(file = 'U:/MyStuff/cls/p205c/EXAMPLES/holzinger/r/hs39all_raw.txt',
                       na = '.')
#-------------------------------------------------------------------------------------------------#
# NOTE: Read in the "raw-scored" version of the Holzinger-Swineford 1939 data                     #
#-------------------------------------------------------------------------------------------------#
head(hs39all)
dim(hs39all)

names(hs39all) = c('case'    , 'school'  , 'grade'   , 'female'  , 'ageyr'  , 'mo'      , 'agemo', 
                   'visperc' , 'cubes'   , 'frmbord' , 'lozenges', 'geninfo', 'paracomp',
                   'sentcomp', 'wordclas', 'wordmean', 'addition', 'code'   , 'countdot', 
                   'sccaps'  , 'wordrecg', 'numbrecg', 'figrrecg', 'objnumb', 'numbfig' , 
                   'figword' , 'deducton', 'numbpuzz', 'probreas', 'series' , 'woody'   , 
                   'frmbord2', 'flags'   )
head(hs39all)


#-------------------------------------------------------------------------------------------------#
# Holzinger-Swineford 1939 data: CONFIGURALINVARIANCE                                             #
#-------------------------------------------------------------------------------------------------#


hs.model1 = '
            spatial  =~ visperc  + cubes    + lozenges
            verbal   =~ geninfo  + paracomp + sentcomp 
            memory   =~ wordrecg + numbrecg + numbfig
            reason   =~ deducton + numbpuzz + series
            '

fit1 = cfa(hs.model1, data = hs39all, group="female")
summary(fit1, fit.measures = TRUE, standardized = TRUE)
inspect(fit1)


#-------------------------------------------------------------------------------------------------#
# Holzinger-Swineford 1939 data: WEAK FACTORIAL INVARIANCE                                        #
#-------------------------------------------------------------------------------------------------#

hs.model2 = '
            spatial  =~ visperc  + cubes    + lozenges
            verbal   =~ geninfo  + paracomp + sentcomp 
            memory   =~ wordrecg + numbrecg + numbfig
            reason   =~ deducton + numbpuzz + series
            '

fit2 = cfa(hs.model2, data = hs39all, group="female",
           group.equal=c("loadings") )
summary(fit2, fit.measures = TRUE, standardized = TRUE)
inspect(fit2)


#-------------------------------------------------------------------------------------------------#
# Holzinger-Swineford 1939 data: STRONG FACTORIAL INVARIANCE                                      #
#-------------------------------------------------------------------------------------------------#

hs.model3 = '
            spatial  =~ visperc  + cubes    + lozenges
            verbal   =~ geninfo  + paracomp + sentcomp 
            memory   =~ wordrecg + numbrecg + numbfig
            reason   =~ deducton + numbpuzz + series
            '

fit3 = cfa(hs.model3, data = hs39all, group="female",
           group.equal=c("loadings", "intercepts") )
summary(fit3, fit.measures = TRUE, standardized = TRUE)
inspect(fit3)


#-------------------------------------------------------------------------------------------------#
# Holzinger-Swineford 1939 data: STRONG FACTORIAL INVARIANCE, WITH ONE MODIFICATION               #
#-------------------------------------------------------------------------------------------------#

hs.model3a = '
           #loadings of MVs on LVs
            spatial  =~ visperc  + cubes    + lozenges
            verbal   =~ geninfo  + paracomp + sentcomp 
            memory   =~ wordrecg + numbrecg + numbfig
            reason   =~ deducton + numbpuzz + series

           #intercepts of MVs
            geninfo ~ c(N04, N05)*1
            '

fit3a = sem(hs.model3a, data = hs39all, group="female",
           group.equal=c("loadings", "intercepts") )
summary(fit3a, fit.measures = TRUE, standardized = TRUE)
inspect(fit3a)


#-------------------------------------------------------------------------------------------------#
# Holzinger-Swineford 1939 data: STRICT FACTORIAL INVARIANCE, with one modification               #
#-------------------------------------------------------------------------------------------------#

hs.model4 = '
            spatial  =~ visperc  + cubes    + lozenges
            verbal   =~ geninfo  + paracomp + sentcomp 
            memory   =~ wordrecg + numbrecg + numbfig
            reason   =~ deducton + numbpuzz + series

           #intercepts of MVs
            geninfo ~ c(N04, N05)*1
            '

fit4 = cfa(hs.model4, data = hs39all, group="female",
           group.equal=c("loadings", "intercepts", "residuals") )
summary(fit4, fit.measures = TRUE, standardized = TRUE)
inspect(fit4)



